 ; Circut - insert a block on the intersection of two or more lines, cut an
 ; appropriate sized chunk out of each one.
 ; Copyright 1994, 2010 by Rocket Software Ltd.
 ; Why are there sugar cubes but no milk cubes?
 (DEFUN C:CIRCUT (/ rota rrota scal pa pb pc ss xa xb)
  (setq name (getstring))
  (setq dist (getdist))
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Try to load Misps.lsp, which contains the subroutines for scaling     
 ;   differently in model and paper space.                                 
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
  (setq dist (* dist scal))
  (setq pa (getpoint "Insertion point:"))
  (setq pb (osnap pa "Intersec"))         ; look for an intersection
  (if pb (setq pa pb)                     ; if an intersec, use it
         (setq pc (osnap pa "nearest")))  ; if no int found, try for nearest
  (if pc (setq pa pc))                    ; if a nearest, go for it
  (setq ss (ssget "C" pa pa))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (if (/= (cdr (assoc 0 (entget enam))) "LINE")
             (ssdel enam ss)
             (setq num (1+ num))))
  (if (and ss (> (sslength ss) 0))
      (progn
           (while (setq enam (ssname ss 0))
                  (setq entt (entget enam))
                  (setq rota (angle (cdr (assoc 10 entt))
                                    (cdr (assoc 11 entt))))
                  (if (and (> rota (/ pi 2)) (<= rota (* pi 1.5)))
                      (setq rota (+ rota pi)))
                  (setq rrota (/ (* 180 rota) pi))
                  (setq xa (polar pa rota dist))
                  (setq xb (polar pa rota (- dist)))
                  (command "break" pa "f" xa xb)
                  (ssdel enam ss))))
  (if (null rrota) (setq rrota 0))
;  (command "insert" name pa scal "" rrota)    ; insert and rotate
  (command "insert" name pa scal "" 0)         ; insert, no rotation
 (princ))